<?php

namespace App\Modules\Passenger\Application\Enable;

use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\BookingTourPassenger\Application\ListByPassenger\BookingTourPassengerPassengerLister;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerRepository;
use Illuminate\Support\Facades\DB;

final class PassengerEnabler
{
    public function __construct(
        private PassengerRepository $repository,
        private BookingTourPassengerPassengerLister $bookingTourPassengerLister,
        private PassengerUpdater $passengerUpdater,
    ) {
    }

    public function __invoke(IdPassenger $idPassenger): EnablePassengerResponse
    {
        $bookingTourPassenger = $this->bookingTourPassengerLister->__invoke($idPassenger)->response()['Response_Data'];

        foreach ($bookingTourPassenger as $btp) {
            DB::select('CALL sp_booking_tour_passenger_enable(?,@sts,@cod,@msg)', [$btp->Id_BookingTourPassenger]);
        }
        $this->passengerUpdater->updateLockHtlCampBookingPassenger($idPassenger->value());

        return new EnablePassengerResponse($this->repository->enable($idPassenger));
    }
}
