<?php

namespace App\Modules\Passenger\Application\Deny;

use App\Modules\BookingTourPassenger\Application\ListByPassenger\BookingTourPassengerPassengerLister;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerRepository;
use Illuminate\Support\Facades\DB;

final class PassengerDenier
{
    public function __construct(
        private PassengerRepository $repository,
        private BookingTourPassengerPassengerLister $bookingTourPassengerLister
    ) {
    }

    public function __invoke(IdPassenger $idPassenger): DenyPassengerResponse
    {
        return new DenyPassengerResponse($this->repository->deny($idPassenger));
    }
}
