<?php

namespace App\Modules\Passenger\Application\Confirm;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerConfirmMessage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ConfirmPassengerQueryHandler implements QueryHandler
{
    public function __construct(private PassengerConfirmer $enabler)
    {
    }

    public function __invoke(ConfirmPassengerQuery $query): ConfirmPassengerResponse
    {
        return $this->enabler->__invoke(
            new IdPassenger($query->id()),
            new PassengerConfirmMessage($query->message())
        );
    }
}
