<?php

namespace App\Modules\Media\Domain;

class MediaData
{

    public function __construct(
        private string $thumbnail,
        private string $largeThumbnail,
        private string $url,
        private string $extension,
        private int $filesize,
        private int $mediaType
    ) {
    }

    public function getThumbnail()
    {
        return $this->thumbnail;
    }

    public function getLargeThumbnail()
    {
        return $this->largeThumbnail;
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function getExtension()
    {
        return $this->extension;
    }

    public function getFilesize()
    {
        return $this->filesize;
    }

    public function getMediaType()
    {
        return $this->mediaType;
    }
}
