<?php

namespace App\Modules\Machupicchu\Application\AvailabilityList;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class MachupicchuAvailabilityListerQueryHandler implements QueryHandler
{
    public function __construct(private MachupicchuAvailabilityLister $inserter)
    {
    }

    public function __invoke(MachupicchuAvailabilityListerQuery $query): MachupicchuAvailabilitiesResponse
    {
        return $this->inserter->__invoke(
            $query->year(),
            $query->idRoute(),
            $query->month()
        );
    }
}
