<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Index;

use App\Modules\LeadBookingTourPassenger\Application\Index\LeadBookingTourPassengerIndexerResponse;
use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerRepository;

final class LeadBookingTourPassengerIndexer
{
    public function __construct(private LeadBookingTourPassengerRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingTourPassenger $idLeadBookingTourPassenger): LeadBookingTourPassengerIndexerResponse
    {
        return new LeadBookingTourPassengerIndexerResponse($this->repository->index($idLeadBookingTourPassenger));
    }
}
