<?php

namespace App\Modules\LeadBookingTour\Application\Update;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourAddress;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourContactName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourContactPhone;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourDateStart;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourEmail;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGender;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourLastName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourNoDocument;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourNoPax;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPhone;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPhoneCode;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPickUp;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourStatus;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourType;
use App\Modules\LeadBookingTour\Domain\UpdateLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadBookingTourUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourUpdater $updater)
    {
    }

    public function __invoke(LeadBookingTourUpdaterQuery $query): LeadBookingTourUpdaterResponse
    {
        $model = new UpdateLeadBookingTour(
            new LeadBookingTourDateStart($query->getDateStart()),
            new LeadBookingTourPickUp($query->getPickUp()),
            new LeadBookingTourType($query->getType()),
            new LeadBookingTourNoPax($query->getNoPax()),
            new LeadBookingTourStatus($query->getStatus()),
            new IdLeadBookingTour($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
