<?php

namespace App\Modules\LeadBookingTour\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTour\Application\List\LeadBookingTourListerResponse;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;

final class LeadBookingTourLister
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(IdLeadBooking $idLeadBooking, string $action): LeadBookingTourListerResponse
    {
        return new LeadBookingTourListerResponse($this->repository->find($idLeadBooking, $action));
    }
}
