<?php

namespace App\Modules\Image\Infraestructure;

use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Image\Domain\IdImage;
use App\Modules\Image\Domain\Image;
use App\Modules\Image\Domain\ImagePath;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Shared\Application\WrapperResponse;
use App\Modules\Shared\DbQuery\Domain\DbCallActionSafely;
use App\Modules\Shared\DbQuery\Domain\DbCallInsertSafely;
use App\Modules\Shared\DbQuery\Domain\DbCallSelectSafely;
use App\Modules\Shared\Domain\RequestAction;
use App\Modules\Shared\Validator\Domain\ListInput;

class MysqlImageRepository implements ImageRepository {

    private DbCallSelectSafely $dbCallSelectSafely;
    private DbCallActionSafely $dbCallActionSafely;
    private DbCallInsertSafely $dbCallInsertSafely;

    public const pPrint = 2;
    public static $domain = 'Type Payment';

    public function __construct() {
        $this->dbCallSelectSafely = new DbCallSelectSafely();
        $this->dbCallActionSafely = new DbCallActionSafely();
        $this->dbCallInsertSafely = new DbCallInsertSafely();
    }

    public function insert (Image $image, IdLanguage $idLanguage):WrapperResponse {
        return $this->dbCallInsertSafely->__invoke(
            'CALL sp_cms_image_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $image->getUrl()->getValue(),
                $image->getThumbUrl()->getValue(),
                $image->getFilesize()->getValue(),
                $image->getExtension()->getValue(),
                $image->getStatus()->getValue(),
                $idLanguage->getValue()
            ],
            self::$domain
        );
    }

    public function update (Image $image, IdLanguage $idLanguage):WrapperResponse {
        return $this->dbCallActionSafely->__invoke(
            'CALL sp_cms_image_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $image->getUrl()->getValue(),
                $image->getThumbUrl()->getValue(),
                $image->getFilesize()->getValue(),
                $image->getExtension()->getValue(),
                $image->getStatus()->getValue(),
                $image->getId()->getValue(),
                $idLanguage->getValue()
            ],
            self::$domain
        );
    }
    
    public function index(IdImage $id, IdLanguage $idLanguage, ImagePath $imagePath) {
        $image = $this->dbCallSelectSafely->__invoke(
            'CALL sp_cms_image_index(?,?,?,@sts,@cod,@msg)',
            [
                $id->getValue(),
                $imagePath->getValue(),
                $idLanguage->getValue()
            ],
            self::$domain
        );

        if (!count($image)) {
            return null;
        }
        return $image[0];
    }
    
    public function list(RequestAction $action, ListInput $listInput, ImagePath $imagePath) {
        $image = $this->dbCallSelectSafely->__invoke(
            'CALL sp_cms_image_list(?,?,?,?,@sts,@cod,@msg)',
            [
                $imagePath->getValue(),
                $action->getValue(),
                $listInput->getOffset(),
                $listInput->getLimit()
            ],
            self::$domain
        );
        
        return $image;
    }

    public function listCount(RequestAction $action, ListInput $listInput) {
        $image = $this->dbCallSelectSafely->__invoke(
            'CALL sp_cms_image_list_count(?,@sts,@cod,@msg)',
            [
                $action->getValue()
            ],
            self::$domain
        );
        
        return $image;
    }
    
    public function remove(IdImage $id, IdLanguage $idLanguage):WrapperResponse {
        return $this->dbCallActionSafely->__invoke(
            'CALL sp_cms_image_delete(?,?,@sts,@cod,@msg)',
            [
                $id->getValue(),
                $idLanguage->getValue()
            ],
            self::$domain
        );
    }

}