<?php

namespace App\Modules\Image\Domain;

use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Shared\Application\WrapperResponse;
use App\Modules\Shared\Domain\RequestAction;
use App\Modules\Shared\Validator\Domain\ListInput;

interface ImageRepository {

    public function index(IdImage $id, IdLanguage $idLanguage, ImagePath $imagePath);
    public function list(RequestAction $action, ListInput $listInput, ImagePath $imagePath);
    public function listCount(RequestAction $action, ListInput $listInput);
    public function insert(Image $value, IdLanguage $idLanguage):WrapperResponse;
    public function remove(IdImage $id, IdLanguage $idLanguage):WrapperResponse;

}