<?php

namespace App\Modules\HtlTypeRoomBed\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoomBed\Application\HtlTypeRoomBedResponse;
use App\Modules\HtlTypeRoomBed\Application\HtlTypeRoomBedResponses;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBed;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlTypeRoomBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomBedLister $lister)
    {
    }

    public function __invoke(ListHtlTypeRoomBedQuery $query): HtlTypeRoomBedResponses
    {
        return new HtlTypeRoomBedResponses(...array_map(
            fn (HtlTypeRoomBed $index) => new HtlTypeRoomBedResponse(
                $index->id()->value(),
                $index->status()->value(),
                $index->idHtlTypeRoom()->value(),
                $index->idHtlBed()->value(),
            ),
            $this->lister->__invoke(new IdHtlTypeRoom($query->getIdHtlTypeRoom()), $query->getAction())
        ));
    }
}
