<?php

namespace App\Modules\HtlTypeCamp\Application\Update;

use App\Modules\HtlTypeCamp\Application\Index\HtlTypeCampIndexer;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampAbrv;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampName;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlTypeCampQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeCampUpdater $updater,
        private HtlTypeCampIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlTypeCampQuery $query): UpdateHtlTypeCampResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeCamp($query->id()), true);
        $index->setName(new HtlTypeCampName($query->name()));
        $index->setAbrv(new HtlTypeCampAbrv($query->abrv()));
        $index->setStatus(new HtlTypeCampStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateHtlTypeCampResponse();
    }
}
