<?php

namespace App\Modules\HtlTypeCamp\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlTypeCamp\Application\HtlTypeCampResponse;
use App\Modules\HtlTypeCamp\Application\HtlTypeCampResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlTypeCampQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeCampLister $lister)
    {
    }

    public function __invoke(ListHtlTypeCampQuery $query): HtlTypeCampResponses
    {
        return new HtlTypeCampResponses(...array_map(
            fn ($index) => new HtlTypeCampResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
