<?php

namespace App\Modules\HtlTypeCamp\Application\Create;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampAbrv;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampName;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampStatus;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampType;
use App\Modules\HtlTypeCamp\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlTypeCampQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeCampCreator $creator)
    {
    }

    public function __invoke(CreateHtlTypeCampQuery $query): CreateHtlTypeCampResponse
    {
        $model = new HtlTypeCamp(
            new IdHtlTypeCamp(0),
            new HtlTypeCampName($query->name()),
            new HtlTypeCampAbrv($query->abrv()),
            new HtlTypeCampStatus($query->status()),
        );
        return new CreateHtlTypeCampResponse($this->creator->__invoke($model));
    }
}
