<?php

namespace App\Modules\HtlCampSchedule\Application\Index;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleRepository;
use App\Modules\HtlCampSchedule\Domain\IndexHtlCampSchedule;

final class HtlCampScheduleIndexer
{
    public function __construct(private HtlCampScheduleRepository $repository)
    {
    }

    public function __invoke(IdHtlCampSchedule $idHtlCampSchedule, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlCampSchedule($idHtlCampSchedule, $lockInShare));
        return $index;
    }
}
