<?php

namespace App\Modules\HtlCampSchedule\Application\Find;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FindHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleFinder $availabilityFinder)
    {
    }

    public function __invoke(FindHtlCampScheduleQuery $query): HtlCampScheduleResponse
    {
        $model = $this->availabilityFinder->__invoke(
            new IdHtlCamp($query->getIdHtlCamp()),
            new HtlCampScheduleDateSchedule($query->getDateSchedule())
        );
        return new HtlCampScheduleResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateSchedule()->value(),
            $model->fromCamp()->value(),
            $model->availability()->value(),
            $model->amountUsage()->value(),
            $model->lock()->value(),
            $model->idHtlCamp()->value()
        );
    }
}
