<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlCampLock implements StorageCriteria
{

    public function __construct(
        private IdHtlCampSchedule $idHtlCampSchedule,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampLock::select('`hcl`');
        if ($this->action == 'all') {
            $where = '`hcl`.`HtlCampLock_Status` IN (1, 2, 3)';
        } else if ($this->action == 'finished') {
            $where = '`hcl`.`HtlCampLock_Status` = 2';
        } else if ($this->action == 'pending') {
            $where = '`hcl`.`HtlCampLock_Status` = 1';
        } else if ($this->action == 'cancelled') {
            $where = '`hcl`.`HtlCampLock_Status` = 3';
        } else if ($this->action == 'deleted') {
            $where = '`hcl`.`HtlCampLock_Status` = 0';
        } else {
            $where = '`hcl`.`HtlCampLock_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_lock` `hcl`
            WHERE `hcl`.`Id_HtlCampSchedule` = ?
            AND $where",
            [$this->idHtlCampSchedule->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
