<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class HtlCampLockStatus extends EnumValueObject
{

    public const DELETED = 0;
    public const PENDING = 1;
    public const FINISHED = 2;
    public const CANCELLED = 3;

    public static function values(): array
    {
        return [self::DELETED, self::PENDING, self::FINISHED, self::CANCELLED];
    }

    public static function defaultValue()
    {
        return new self(self::PENDING);
    }

    public static function deletedValue()
    {
        return new self(self::DELETED);
    }
}
