<?php

namespace App\Modules\HtlCampLock\Application\Find;

use App\Modules\HtlCampLock\Domain\ExistsHtlCampLock;
use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\HtlCampLock\Domain\HtlCampLockRepository;

final class HtlCampLockFinder
{
    public function __construct(private HtlCampLockRepository $repository)
    {
    }

    public function __invoke(IdHtlCampLock $idHtlCampLock, bool $lockInShare = true)
    {
        $index = $this->repository->find(new ExistsHtlCampLock($idHtlCampLock, $lockInShare));
        return $index;
    }
}
