<?php

namespace App\Modules\HtlCampLock\Application\Delete;

use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\HtlCampLock\Application\Index\HtlCampLockIndexer;
use App\Modules\HtlCampLock\Application\Update\HtlCampLockUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampLockUpdater $update,
        private HtlCampLockIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlCampLockQuery $query): DeleteHtlCampLockResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampLock($query->idHtlCampLock()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlCampLockResponse();
    }
}
