<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlCampBookingPassenger extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampBookingPassenger::class, 'Id_HtlCampBookingPassenger', 'primary'),
            new AggregateAttribute('weight', HtlCampBookingPassengerWeight::class, 'HtlCampBookingPassenger_Weight'),
            new AggregateAttribute('status', HtlCampBookingPassengerStatus::class, 'HtlCampBookingPassenger_Status'),
            new AggregateAttribute('idHtlCampBooking', IdHtlCampBooking::class, 'Id_HtlCampBooking'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking_passenger';
    }

    public function __construct(
        protected IdHtlCampBookingPassenger $id,
        protected HtlCampBookingPassengerWeight $weight,
        protected HtlCampBookingPassengerStatus $status,
        protected IdHtlCampBooking $idHtlCampBooking,
        protected IdBookingTourPassenger $idBookingTourPassenger
    ) {
    }

    public function id(): IdHtlCampBookingPassenger
    {
        return $this->id;
    }

    public function weight(): HtlCampBookingPassengerWeight
    {
        return $this->weight;
    }

    public function status(): HtlCampBookingPassengerStatus
    {
        return $this->status;
    }

    public function idHtlCampBooking(): IdHtlCampBooking
    {
        return $this->idHtlCampBooking;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }

    public function setWeight(HtlCampBookingPassengerWeight $weight): void
    {
        $this->weight = $weight;
    }

    public function setStatus(HtlCampBookingPassengerStatus $status): void
    {
        $this->status = $status;
    }

    public function delete(): void
    {
        $this->status = HtlCampBookingPassengerStatus::deletedValue();
    }
}
