<?php

namespace App\Modules\HtlCampBookingPassenger\Application\ListByPassenger;

use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Domain\ListByPassengerHtlCampBookingPassenger;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class ByPassengerHtlCampBookingPassengerLister
{
    public function __construct(private HtlCampBookingPassengerRepository $repository)
    {
    }

    public function __invoke(IdBookingTourPassenger $idBookingTourPassenger, string $action)
    {
        return $this->repository->searchByPassenger(
            new ListByPassengerHtlCampBookingPassenger(
                $idBookingTourPassenger,
                $action
            )
        );
    }
}
