<?php

namespace App\Modules\HtlCampBookingPassenger\Application\ListByHtlCampSchedule;

use App\Modules\HtlCampBookingPassenger\Domain\ListByScheduleHtlCampBookingPassengerModel;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByHtlCampScheduleHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(private ByHtlCampScheduleHtlCampBookingPassengerLister $lister) {}

    public function __invoke(ListByHtlCampScheduleHtlCampBookingPassengerQuery $query): ListByHtlCampScheduleHtlCampBookingPassengerResponses
    {
        return new ListByHtlCampScheduleHtlCampBookingPassengerResponses(...array_map(
            fn(ListByScheduleHtlCampBookingPassengerModel $index) => new ListByHtlCampScheduleHtlCampBookingPassengerResponse(
                $index->Id_HtlCampBookingPassenger->value(),
                $index->HtlCampBookingPassenger_Status->value(),
                $index->Id_Invoice->value(),
                $index->Invoice_TotalPending->value(),
                $index->Invoice_Total->value(),
                $index->Id_Passenger->value(),
                $index->Passenger_ImgDocument1->value(),
                $index->Passenger_Gender->value(),
                $index->Passenger_DOB->value(),
                $index->BookingTour_DateStart->value(),
                $index->BookingTour_TourDuration->value(),
                $index->Passenger_CheckedInStatus->value(),
                $index->Passenger_InfoStatus->value(),
                $index->Passenger_PaymentStatus->value(),
                $index->Id_BookingTourPassenger->value(),
                $index->BookingTourPassenger_HasBeenPrinted->value(),
                $index->BookingTourPassenger_Status->value(),
                $index->BookingTour_Status->value(),
                $index->Passenger_Name->value(),
                $index->Passenger_LastName->value(),
                $index->Id_UserCountry->value(),
                $index->UserCountry_Name->value(),
                $index->UserCountry_Code->value(),
                $index->UserCountry_PhoneCode->value(),
                $index->UserCountry_Img->value(),
                $index->UserCountry_Status->value(),
                $index->Id_Tour->value(),
                $index->Tour_Name->value(),
                $index->Tour_Code->value(),
                $index->Tour_Color->value(),
                $index->Id_User->value(),
                $index->User_Type->value(),
                $index->Id_Booking->value(),
                $index->Booking_Type->value(),
                $index->Booking_InPerson->value(),
                $index->Booking_Code->value(),
                $index->Id_Admin->value(),
                $index->Admin_Name->value(),
                $index->Admin_LastName->value(),
                $index->Admin_Abrv->value(),
                $index->Admin_Color->value(),
                $index->Admin_ImgProfile_Thumb->value(),
                $index->Id_AdminRole->value(),
                $index->AdminRole_Name->value(),
                $index->GroupList->value(),
                $index->Group_Count->value(),
                $index->Id_Group ? $index->Id_Group->value() : null,
            ),
            $this->lister->__invoke(new IdHtlCampSchedule($query->getIdHtlCampSchedule()), $query->getAction())
        ));
    }
}
