<?php

namespace App\Modules\HtlCampBooking\Application\UpdateStatus;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateStatusHtlCampBookingQuery implements Query
{
    public function __construct(
        private int $id,
        private string $date,
        private int $status,
        private int $lock,
        private string $remark,
        private int $idHtlCampSchedule,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function date(): string
    {
        return $this->date;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function lock(): int
    {
        return $this->lock;
    }

    public function remark(): string
    {
        return $this->remark;
    }

    public function idHtlCampSchedule(): int
    {
        return $this->idHtlCampSchedule;
    }
}
