<?php

namespace App\Modules\HtlCampBooking\Application\List;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampBooking\Domain\ListHtlCampBookingModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingLister $lister)
    {
    }

    public function __invoke(ListHtlCampBookingQuery $query): ListHtlCampBookingResponses
    {
        return new ListHtlCampBookingResponses(...array_map(
            fn (ListHtlCampBookingModel $index) => new ListHtlCampBookingResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateStart()->value(),
                $index->amount()->value(),
                $index->amountTotal()->value(),
                $index->status()->value(),
                $index->lock()->value(),
                $index->remark()->value(),
                $index->idHtlCampSchedule()->value(),
                $index->idBookingTour()->value(),
                $index->idHtlCamp()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->icon()->value(),
                $index->iconThumb()->value(),
            ),
            $this->lister->__invoke(new IdBookingTour($query->getIdBookingTour()), $query->getAction())
        ));
    }
}
