<?php

namespace App\Modules\HtlCampBooking\Application\Index;

use App\Modules\HtlCampBooking\Application\HtlCampBookingResponse;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlCampBookingQuery $query): HtlCampBookingResponse
    {
        $model = $this->inserter->__invoke(new IdHtlCampBooking($query->getId()));
        return new HtlCampBookingResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateStart()->value(),
            $model->amount()->value(),
            $model->status()->value(),
            $model->lock()->value(),
            $model->remark()->value(),
            $model->idHtlCampSchedule()->value(),
            $model->idBookingTour()->value(),
        );
    }
}
