<?php

namespace App\Modules\HtlCampBooking\Application\Delete;

use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Application\Index\HtlCampBookingIndexer;
use App\Modules\HtlCampBooking\Application\Update\HtlCampBookingUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingUpdater $update,
        private HtlCampBookingIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlCampBookingQuery $query): DeleteHtlCampBookingResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampBooking($query->idHtlCampBooking()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlCampBookingResponse();
    }
}
