<?php

namespace App\Modules\HtlCampBooking\Application\CreateWithPassengers;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateWithPassengersHtlCampBookingQuery implements Query
{
    /**
     * @param array<CreateWithPassengersHtlCampBookingPassenger> $passengers
     * */
    public function __construct(
        private string $dateStart,
        private int $idHtlCamp,
        private int $idBookingTour,
        private array $passengers
    ) {
    }

    public static function fromEmptyBookingTour($bookingTour, $idHtlCamp)
    {
        return new self(
            $bookingTour->BookingTour_DateStart,
            $idHtlCamp,
            $bookingTour->Id_BookingTour,
            []
        );
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }

    public function idBookingTour(): int
    {
        return $this->idBookingTour;
    }

    public function passengers(): array
    {
        return $this->passengers;
    }
}
