<?php

namespace App\Modules\HtlBed\Domain;

use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFromTypeRoom implements StorageCriteria
{

    public function __construct(
        private IdHtlTypeRoom $idHtlTypeRoom,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlBed::select('`hb`');
        if ($this->action == 'all') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 0';
        } else {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_type_room_bed` `htrb`
            INNER JOIN `t_htl_bed` `hb` ON `hb`.`Id_HtlBed` = `htrb`.`Id_HtlBed`
            WHERE $where
            AND `htrb`.`Id_HtlTypeRoom` = ?",
            [$this->idHtlTypeRoom->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
