<?php

namespace App\Modules\History\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Record\Domain\IdRecord;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class History extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHistory::class, 'Id_History', 'primary'),
            new AggregateAttribute('date', HistoryDate::class, 'History_Date'),
            new AggregateAttribute('valueOld', HistoryValueOld::class, 'History_ValueOld'),
            new AggregateAttribute('valueNew', HistoryValueNew::class, 'History_ValueNew'),
            new AggregateAttribute('operation', HistoryOperation::class, 'History_Operation'),
            new AggregateAttribute('idRecord', IdHistoryRecord::class, 'Id_Record'),
            new AggregateAttribute('idReference', IdHistoryReference::class, 'Id_Reference'),
            new AggregateAttribute('idHistoryTable', IdHistoryTable::class, 'Id_HistoryTable'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
        ];
    }

    protected static function table(): string
    {
        return 't_history';
    }

    public function __construct(
        private IdHistory $id,
        private HistoryDate $date,
        private HistoryValueOld $valueOld,
        private HistoryValueNew $valueNew,
        private HistoryOperation $operation,
        private IdHistoryRecord $idRecord,
        private IdHistoryReference $idReference,
        private IdHistoryTable $idHistoryTable,
        private IdAdmin $idAdmin,
    ) {
    }

    public function id(): IdHistory
    {
        return $this->id;
    }

    public function date(): HistoryDate
    {
        return $this->date;
    }

    public function valueOld(): HistoryValueOld
    {
        return $this->valueOld;
    }

    public function valueNew(): HistoryValueNew
    {
        return $this->valueNew;
    }

    public function operation(): HistoryOperation
    {
        return $this->operation;
    }

    public function idRecord(): IdHistoryRecord
    {
        return $this->idRecord;
    }

    public function idReference(): IdHistoryReference
    {
        return $this->idReference;
    }

    public function idHistoryTable(): IdHistoryTable
    {
        return $this->idHistoryTable;
    }

    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    public static function generate(
        HistoryValueOld $valueOld,
        HistoryValueNew $valueNew,
        HistoryOperation $operation,
        IdHistoryRecord $idRecord,
        IdHistoryReference $idReference,
        IdHistoryTable $idHistoryTable,
        IdAdmin $idAdmin,
    ) {
        return new History(
            new IdHistory(0),
            HistoryDate::now(),
            $valueOld,
            $valueNew,
            $operation,
            $idRecord,
            $idReference,
            $idHistoryTable,
            $idAdmin,
        );
    }
}
