<?php

namespace App\Modules\GroupProviderMedia\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexGroupProviderMedia implements StorageCriteria
{

    public function __construct(
        private IdGroupProviderMedia $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProviderMedia::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_group_provider_media` `htc`
            WHERE `htc`.`Id_GroupProviderMedia` = ?
            AND `htc`.`GroupProviderMedia_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new GroupProviderMediaNotFound();
        }
        return $data[0];
    }
}
