<?php

namespace App\Modules\GroupProviderMedia\Application\List;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderMedia\Application\GroupProviderMediaResponse;
use App\Modules\GroupProviderMedia\Application\GroupProviderMediaResponses;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMedia;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListGroupProviderMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderMediaLister $lister)
    {
    }

    public function __invoke(ListGroupProviderMediaQuery $query): GroupProviderMediaResponses
    {
        return new GroupProviderMediaResponses(...array_map(
            fn (GroupProviderMedia $index) => new GroupProviderMediaResponse(
                $index->id()->value(),
                $index->path()->value(),
                $index->pathThumb()->value(),
                $index->pathLargeThumb()->value(),
                $index->description()->value(),
                $index->extension()->value(),
                $index->size()->value(),
                $index->type()->value(),
                $index->hasThumbnail()->value(),
                $index->error()->value(),
                $index->status()->value(),
                $index->idGroupProvider()->value(),
            ),
            $this->lister->__invoke(new IdGroupProvider($query->idGroupProvider()), $query->getAction())
        ));
    }
}
