<?php

namespace App\Modules\GroupProviderMedia\Application\List;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaRepository;
use App\Modules\GroupProviderMedia\Domain\ListGroupProviderMedia;

final class GroupProviderMediaLister
{
    public function __construct(private GroupProviderMediaRepository $repository)
    {
    }

    public function __invoke(IdGroupProvider $idGroupProvider, string $action)
    {
        return $this->repository->search(new ListGroupProviderMedia($idGroupProvider, $action));
    }
}
