<?php

namespace App\Modules\GroupPassengerMedia\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexGroupPassengerMedia implements StorageCriteria
{

    public function __construct(
        private IdGroupPassengerMedia $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupPassengerMedia::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_group_passenger_media` `htc`
            WHERE `htc`.`Id_GroupPassengerMedia` = ?
            AND `htc`.`GroupPassengerMedia_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new GroupPassengerMediaNotFound();
        }
        return $data[0];
    }
}
