<?php

namespace App\Modules\GroupPassengerMedia\Application\Update;

use App\Modules\GroupPassengerMedia\Application\Index\GroupPassengerMediaIndexer;
use App\Modules\GroupPassengerMedia\Domain\IdGroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaError;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaExtension;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPath;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPathLargeThumb;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPathThumb;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaSize;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaStatus;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateGroupPassengerMediaQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupPassengerMediaUpdater $updater,
        private GroupPassengerMediaIndexer $indexer
    ) {
    }

    public function __invoke(UpdateGroupPassengerMediaQuery $query): UpdateGroupPassengerMediaResponse
    {
        $index = $this->indexer->__invoke(new IdGroupPassengerMedia($query->id()), true);
        $index->setPath(new GroupPassengerMediaPath($query->path()));
        $index->setPathThumb(new GroupPassengerMediaPathThumb($query->pathThumb()));
        $index->setPathLargeThumb(new GroupPassengerMediaPathLargeThumb($query->pathLargeThumb()));
        $index->setExtension(new GroupPassengerMediaExtension($query->extension()));
        $index->setSize(new GroupPassengerMediaSize($query->size()));
        $index->setType(new GroupPassengerMediaType($query->type()));
        $index->setError(new GroupPassengerMediaError($query->error()));
        $index->setStatus(new GroupPassengerMediaStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateGroupPassengerMediaResponse();
    }
}
