<?php

namespace App\Modules\GroupPassengerMedia\Application\Delete;

use App\Modules\GroupPassengerMedia\Domain\IdGroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Application\Index\GroupPassengerMediaIndexer;
use App\Modules\GroupPassengerMedia\Application\Update\GroupPassengerMediaUpdater;
use App\Modules\Media\Application\Delete\DeleteMediaQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteGroupPassengerMediaQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupPassengerMediaUpdater $update,
        private GroupPassengerMediaIndexer $indexer,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(DeleteGroupPassengerMediaQuery $query): DeleteGroupPassengerMediaResponse
    {
        $index = $this->indexer->__invoke(new IdGroupPassengerMedia($query->idGroupPassengerMedia()), true);
        $index->delete();
        $this->update->__invoke($index);
        $this->queryBus->ask(new DeleteMediaQuery($index->path()->value()));
        $this->queryBus->ask(new DeleteMediaQuery($index->pathThumb()->value()));
        return new DeleteGroupPassengerMediaResponse();
    }
}
