<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexGroupPassenger implements StorageCriteria
{

    public function __construct(
        private IdGroupPassenger $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupPassengerModel::select('`gp`');

        return DB::select(
            "SELECT $select
            FROM `t_group_passenger` `gp`
            WHERE `gp`.`Id_GroupPassenger` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new GroupPassengerNotFound();
        }
        return $data[0];
    }
}
