<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class GroupPassengerMediaStatus extends EnumValueObject
{
    public const NO_UPLOADED = 1;
    public const PENDING = 2;
    public const UPLOADED = 3;
    public const ERROR = 4;
    public const SCORED = 5;
    public const DOWNLOADED = 6;
    public const DELETED = 7;

    public static function values(): array
    {
        return [
            self::NO_UPLOADED,
            self::PENDING,
            self::UPLOADED,
            self::ERROR,
            self::SCORED,
            self::DOWNLOADED,
            self::DELETED
        ];
    }

    public static function changes()
    {
        return [
            self::NO_UPLOADED => [
                self::PENDING,
            ],
            self::PENDING => [
                self::UPLOADED,
                self::SCORED,
                self::DOWNLOADED,
                self::ERROR
            ],
            self::UPLOADED => [
                self::SCORED,
                self::PENDING,
                self::DOWNLOADED
            ],
            self::SCORED => [
                self::PENDING,
                self::UPLOADED,
                self::SCORED,
                self::DOWNLOADED
            ],
            self::DOWNLOADED => [
                self::DOWNLOADED,
                self::UPLOADED,
                self::SCORED,
                self::PENDING,
                self::DELETED
            ],
            self::ERROR => [
                self::PENDING
            ]
        ];
    }

    public static function changeFrom(
        GroupPassengerMediaStatus $from,
        GroupPassengerMediaStatus $to,
    ) {
        $changes = self::changes();
        if (!in_array($to->value, $changes[$from->value])) {
            throw new GroupPassengerFailOnChange();
        }

        return $to;
    }

    public function __construct(int $value)
    {
        parent::__construct($value);
    }
}
