<?php

namespace App\Modules\GroupPassenger\Application\UpdateReview;

use App\Modules\GroupPassenger\Domain\GroupPassengerReviewDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateReviewGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerReviewUpdater $update)
    {
    }

    public function __invoke(UpdateReviewGroupPassengerQuery $query): UpdateReviewGroupPassengerResponse
    {
        return $this->update->__invoke(
            new IdGroupPassenger($query->id()),
            new GroupPassengerReviewStatus($query->reviewStatus()),
            GroupPassengerReviewDateUpdate::reduceDatetimeToPeru(GroupPassengerReviewDateUpdate::now())
        );
    }
}
