<?php

namespace App\Modules\GroupPassenger\Application\ListGallery;

use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\ListGalleryGroupPassenger;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class GalleryGroupPassengerLister
{
    public function __construct(private GroupPassengerRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $search,
        string $action,
        QueryPaginate $queryPaginate,
    ) {
        return $this->repository->search(new ListGalleryGroupPassenger(
            $dateStart,
            $dateEnd,
            $search,
            $action,
            $queryPaginate
        ));
    }
}
