<?php

namespace App\Modules\Group\Application\UpdateDateUpdate;

use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Group\Domain\IdGroup;

final class GroupUpdateDateUpdater
{
    public function __construct(
        private GroupRepositoryAlter $repository,
    ) {
    }

    public function __invoke(
        IdGroup $idGroup
    ): UpdateGroupDateUpdateQueryResponse {
        return new UpdateGroupDateUpdateQueryResponse($this->repository->updateDateUpdate($idGroup));
    }
}
