<?php

namespace App\Modules\Group\Application\Report;

use App\Modules\Group\Application\Report\ReportGroupFinder;
use App\Modules\Group\Application\Report\ReportGroupQuery;
use App\Modules\Group\Application\Report\ReportGroupResponseConverter;
use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;

final class ReportGroupQueryHandler {
    
    private ReportGroupFinder $reportGroupFinder;
    private ReportGroupCounter $reportGroupCounter;
    

    public function __construct(
        ReportGroupFinder $finder,
        ReportGroupCounter $counter
    ) {
        $this->reportGroupFinder = $finder;
        $this->reportGroupCounter = $counter;
    }

    private function finder (...$args) {
        return (new ReportGroupResponseConverter())
        ->__invoke($this->reportGroupFinder->__invoke(...$args));
    }

    public function __invoke(ReportGroupQuery $query): array {
        $dateStart = new GroupDateStart($query->dateStart());
        $dateEnd = new GroupDateEnd($query->dateEnd());

        $response = $this->finder($dateStart, $dateEnd, $query->input());
        $count = $this->reportGroupCounter->__invoke($dateStart, $dateEnd);
        return [
            'Response_Data' => $response,
            'Response_Count' => $count
        ];
    }
}
