<?php

namespace App\Modules\Group\Application\ListGroupProgramming;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class ListGroupProgrammingQueryHandler implements QueryHandler
{
    public function __construct(private GroupProgrammingLister $lister)
    {
    }

    public function __invoke(ListGroupProgrammingQuery $query): ListGroupProgrammingResponses
    {
        return $this->lister->__invoke(
            $query->action(),
            new IdCategoryTour($query->idCategoryTour()),
            new IdTour($query->idTour()),
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->token()
        );
    }
}
