<?php

namespace App\Modules\Group\Application\FillGroupProviderReview;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Tour\Domain\IdTour;

final class FillGroupProviderReviewQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReviewFiller $updater)
    {
    }

    public function __invoke(FillGroupProviderReviewQuery $query): FillGroupProviderReviewQueryResponse
    {
        return new FillGroupProviderReviewQueryResponse(
            $this->updater->__invoke(new IdGroup($query->idGroup()))
        );
    }
}
