<?php

namespace App\Modules\FactUnit\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactUnit implements StorageCriteria
{

    public function __construct(
        private IdFactUnit $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactUnit::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_unit` `ftd`
            WHERE `ftd`.`Id_FactUnit` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactUnitNotFound();
        }
        return $data[0];
    }
}
