<?php

namespace App\Modules\FactUnit\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class FactUnitUpdaterQuery implements Query
{
    public function __construct(
        private string $id,
        private string $leadName,
        private string $leadAbrv,
        private int $leadStatus,
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getName(): string
    {
        return $this->leadName;
    }
    public function getAbrv(): string
    {
        return $this->leadAbrv;
    }
    public function getStatus(): int
    {
        return $this->leadStatus;
    }
}
