<?php

namespace App\Modules\FactTypeOperation\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactTypeOperation implements StorageCriteria
{

    public function __construct(
        private IdFactTypeOperation $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactTypeOperation::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_type_operation` `ftd`
            WHERE `ftd`.`Id_FactTypeOperation` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactTypeOperationNotFound();
        }
        return $data[0];
    }
}
