<?php

namespace App\Modules\FactTypeOperation\Application\Update;

use App\Modules\FactTypeOperation\Application\Update\FactTypeOperationUpdaterResponse;
use App\Modules\FactTypeOperation\Domain\FactTypeOperation;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationRepository;

final class FactTypeOperationUpdater
{
    public function __construct(private FactTypeOperationRepository $repository)
    {
    }

    public function __invoke(FactTypeOperation $lead): FactTypeOperationUpdaterResponse
    {
        return new FactTypeOperationUpdaterResponse($this->repository->update($lead));
    }
}
