<?php

namespace App\Modules\FactTypeDocument\Application\Update;

use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeDocument\Domain\FactTypeDocument;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentAbrv;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentName;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeDocumentUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeDocumentUpdater $updater)
    {
    }

    public function __invoke(FactTypeDocumentUpdaterQuery $query): FactTypeDocumentUpdaterResponse
    {
        $model = new FactTypeDocument(
            new IdFactTypeDocument($query->getId()),
            new FactTypeDocumentName($query->getName()),
            new FactTypeDocumentAbrv($query->getAbrv()),
            new FactTypeDocumentStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
