<?php

namespace App\Modules\FactReceiptDetail\Domain;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactUnit\Domain\FactUnit;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactReceiptDetail extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactReceiptDetail::class, 'Id_FactReceiptDetail'),
            new AggregateAttribute('amount', FactReceiptDetailAmount::class, 'FactReceiptDetail_Amount'),
            new AggregateAttribute('unitPrice', FactReceiptDetailUnitPrice::class, 'FactReceiptDetail_UnitPrice'),
            new AggregateAttribute('discount', FactReceiptDetailDiscount::class, 'FactReceiptDetail_Discount'),
            new AggregateAttribute('total', FactReceiptDetailTotal::class, 'FactReceiptDetail_Total'),
            new AggregateAttribute('status', FactReceiptDetailStatus::class, 'FactReceiptDetail_Status'),
            new AggregateAttribute('idFactProduct', IdFactProduct::class, 'Id_FactProduct'),
            new AggregateAttribute('idFactTypeOperation', IdFactTypeOperation::class, 'Id_FactTypeOperation'),
            new AggregateAttribute('idFactUnit', IdFactUnit::class, 'Id_FactUnit'),
            new AggregateAttribute('idFactReceipt', IdFactReceipt::class, 'Id_FactReceipt'),
        ];
    }

    public FactUnit $unit;

    public function __construct(
        private IdFactReceiptDetail $id,
        private FactReceiptDetailAmount $amount,
        private FactReceiptDetailUnitPrice $unitPrice,
        private FactReceiptDetailDiscount $discount,
        private FactReceiptDetailTotal $total,
        private FactReceiptDetailStatus $status,
        private IdFactProduct | FactProduct $idFactProduct,
        private IdFactTypeOperation $idFactTypeOperation,
        private IdFactUnit $idFactUnit,
        private IdFactReceipt $idFactReceipt,
    ) {
    }

    public function id(): IdFactReceiptDetail
    {
        return $this->id;
    }

    public function amount(): FactReceiptDetailAmount
    {
        return $this->amount;
    }

    public function unitPrice(): FactReceiptDetailUnitPrice
    {
        return $this->unitPrice;
    }

    public function discount(): FactReceiptDetailDiscount
    {
        return $this->discount;
    }

    public function total(): FactReceiptDetailTotal
    {
        return $this->total;
    }

    public function status(): FactReceiptDetailStatus
    {
        return $this->status;
    }

    public function idFactProduct(): IdFactProduct | FactProduct
    {
        return $this->idFactProduct;
    }

    public function idFactTypeOperation(): IdFactTypeOperation
    {
        return $this->idFactTypeOperation;
    }

    public function idFactUnit(): IdFactUnit
    {
        return $this->idFactUnit;
    }

    public function idFactReceipt(): IdFactReceipt
    {
        return $this->idFactReceipt;
    }

    public function setProduct(IdFactProduct | FactProduct $product)
    {
        $this->idFactProduct = $product;
    }

    public function setUnit(FactUnit $unit)
    {
        $this->unit = $unit;
    }
}
